<?php
/**
 * Copyright (c) 2015-present, Facebook, Inc. All rights reserved.
 *
 * You are hereby granted a non-exclusive, worldwide, royalty-free license to
 * use, copy, modify, and distribute this software in source code or binary
 * form for use in connection with the web services and APIs provided by
 * Facebook.
 *
 * As with any software that integrates with the Facebook platform, your use
 * of this software is subject to the Facebook Developer Principles and
 * Policies [http://developers.facebook.com/policy/]. This copyright notice
 * shall be included in all copies or substantial portions of the software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 */

namespace FacebookAds\Object\Values;

use FacebookAds\Enum\AbstractEnum;

/**
 * This class is auto-generated.
 *
 * For any issues or feature requests related to this class, please let us know
 * on github and we'll fix in our codegen framework. We'll not be able to accept
 * pull request for this class.
 *
 * @method static AdAccountTargetingUnifiedLimitTypeValues getInstance()
 */
class AdAccountTargetingUnifiedLimitTypeValues extends AbstractEnum {

  const ADGROUP_ID = 'adgroup_id';
  const GENDERS = 'genders';
  const AGE_MIN = 'age_min';
  const AGE_MAX = 'age_max';
  const COUNTRY_GROUPS = 'country_groups';
  const COUNTRIES = 'countries';
  const COUNTRY = 'country';
  const CITIES = 'cities';
  const RADIUS = 'radius';
  const REGIONS = 'regions';
  const ZIPS = 'zips';
  const INTERESTS = 'interests';
  const KEYWORDS = 'keywords';
  const EDUCATION_SCHOOLS = 'education_schools';
  const EDUCATION_MAJORS = 'education_majors';
  const WORK_POSITIONS = 'work_positions';
  const WORK_EMPLOYERS = 'work_employers';
  const RELATIONSHIP_STATUSES = 'relationship_statuses';
  const INTERESTED_IN = 'interested_in';
  const LOCALES = 'locales';
  const USER_ADCLUSTERS = 'user_adclusters';
  const EXCLUDED_USER_ADCLUSTERS = 'excluded_user_adclusters';
  const CONJUNCTIVE_USER_ADCLUSTERS = 'conjunctive_user_adclusters';
  const CUSTOM_AUDIENCES = 'custom_audiences';
  const EXCLUDED_CUSTOM_AUDIENCES = 'excluded_custom_audiences';
  const COLLEGE_YEARS = 'college_years';
  const EDUCATION_STATUSES = 'education_statuses';
  const CONNECTIONS = 'connections';
  const EXCLUDED_CONNECTIONS = 'excluded_connections';
  const FRIENDS_OF_CONNECTIONS = 'friends_of_connections';
  const USER_EVENT = 'user_event';
  const DYNAMIC_AUDIENCE_IDS = 'dynamic_audience_ids';
  const EXCLUDED_DYNAMIC_AUDIENCE_IDS = 'excluded_dynamic_audience_ids';
  const RTB_FLAG = 'rtb_flag';
  const SITE_CATEGORY = 'site_category';
  const GEO_LOCATIONS = 'geo_locations';
  const EXCLUDED_GEO_LOCATIONS = 'excluded_geo_locations';
  const TIMEZONES = 'timezones';
  const PLACE_PAGE_SET_IDS = 'place_page_set_ids';
  const PAGE_TYPES = 'page_types';
  const PUBLISHER_PLATFORMS = 'publisher_platforms';
  const EFFECTIVE_PUBLISHER_PLATFORMS = 'effective_publisher_platforms';
  const FACEBOOK_POSITIONS = 'facebook_positions';
  const EFFECTIVE_FACEBOOK_POSITIONS = 'effective_facebook_positions';
  const INSTAGRAM_POSITIONS = 'instagram_positions';
  const EFFECTIVE_INSTAGRAM_POSITIONS = 'effective_instagram_positions';
  const MESSENGER_POSITIONS = 'messenger_positions';
  const EFFECTIVE_MESSENGER_POSITIONS = 'effective_messenger_positions';
  const DEVICE_PLATFORMS = 'device_platforms';
  const EFFECTIVE_DEVICE_PLATFORMS = 'effective_device_platforms';
  const AUDIENCE_NETWORK_POSITIONS = 'audience_network_positions';
  const EFFECTIVE_AUDIENCE_NETWORK_POSITIONS = 'effective_audience_network_positions';
  const EXCLUDED_PUBLISHER_CATEGORIES = 'excluded_publisher_categories';
  const EXCLUDED_PUBLISHER_LIST_IDS = 'excluded_publisher_list_ids';
  const PUBLISHER_VISIBILITY_CATEGORIES = 'publisher_visibility_categories';
  const USER_DEVICE = 'user_device';
  const MOBILE_DEVICE_MODEL = 'mobile_device_model';
  const EXCLUDED_USER_DEVICE = 'excluded_user_device';
  const EXCLUDED_MOBILE_DEVICE_MODEL = 'excluded_mobile_device_model';
  const USER_OS = 'user_os';
  const WIRELESS_CARRIER = 'wireless_carrier';
  const FAMILY_STATUSES = 'family_statuses';
  const INDUSTRIES = 'industries';
  const LIFE_EVENTS = 'life_events';
  const POLITICAL_VIEWS = 'political_views';
  const POLITICS = 'politics';
  const BEHAVIORS = 'behaviors';
  const INCOME = 'income';
  const NET_WORTH = 'net_worth';
  const HOME_TYPE = 'home_type';
  const HOME_OWNERSHIP = 'home_ownership';
  const HOME_VALUE = 'home_value';
  const ETHNIC_AFFINITY = 'ethnic_affinity';
  const GENERATION = 'generation';
  const HOUSEHOLD_COMPOSITION = 'household_composition';
  const MOMS = 'moms';
  const OFFICE_TYPE = 'office_type';
  const TARGETING_OPTIMIZATION = 'targeting_optimization';
  const DIRECT_INSTALL_DEVICES = 'direct_install_devices';
  const ENGAGEMENT_SPECS = 'engagement_specs';
  const EXCLUDED_ENGAGEMENT_SPECS = 'excluded_engagement_specs';
  const PRODUCT_AUDIENCE_SPECS = 'product_audience_specs';
  const EXCLUDED_PRODUCT_AUDIENCE_SPECS = 'excluded_product_audience_specs';
  const EXCLUSIONS = 'exclusions';
  const FLEXIBLE_SPEC = 'flexible_spec';
  const EXCLUDE_REACHED_SINCE = 'exclude_reached_since';
  const EXCLUDE_PREVIOUS_DAYS = 'exclude_previous_days';
  const APP_INSTALL_STATE = 'app_install_state';
  const FB_DEAL_ID = 'fb_deal_id';
  const INTEREST_DEFAULTS_SOURCE = 'interest_defaults_source';
  const ALTERNATE_AUTO_TARGETING_OPTION = 'alternate_auto_targeting_option';
  const CONTEXTUAL_TARGETING_CATEGORIES = 'contextual_targeting_categories';
  const TOPIC = 'topic';
  const FORMAT = 'format';
  const TRENDING = 'trending';
  const GATEKEEPERS = 'gatekeepers';
  const FOLLOW_PROFILES = 'follow_profiles';
  const FOLLOW_PROFILES_NEGATIVE = 'follow_profiles_negative';
  const LOCATION_CATEGORIES = 'location_categories';
  const USER_PAGE_THREADS = 'user_page_threads';
  const USER_PAGE_THREADS_EXCLUDED = 'user_page_threads_excluded';
}
